
#version 120

uniform sampler2D bg;
uniform sampler2D obj;
uniform sampler2D objb;

uniform float g[32];

void main()
{
	vec4 bgc = texture2D(bg, gl_TexCoord[0].st);
	vec4 objc = texture2D(obj, gl_TexCoord[0].st);
	
	vec2 d = vec2(0, 0.02);
	vec4 sum = texture2D(objb, gl_TexCoord[0].st) * g[0];
	for (int i = 1; i < 32; i++)
	{
		sum += texture2D(objb, gl_TexCoord[0].st + d * i) * g[i];
		sum += texture2D(objb, gl_TexCoord[0].st - d * i) * g[i];
	}
	
	gl_FragColor = clamp(mix(bgc, objc, objc.w) + sum * 1.0, vec4(0,0,0,0), vec4(1,1,1,1));
}
